<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GalleryLanguage extends Model 
{

    protected $table = 'lim_gallery_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_gallery_id', 'name', 'content');
    protected $visible = array('lim_language_id', 'lim_gallery_id', 'name', 'content');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function gallery()
    {
        return $this->belongsTo('App\Models\Gallery', 'lim_gallery_id');
    }

}